import React, { ComponentType } from 'react';
import { reduxContext, ReduxContextValue } from './reduxContext';
import constants from '../../constants';
import { createCategorizationSlice } from '../../redux/createCategorizationSlice';
import { WithReduxContextProps } from './withReduxContext.types';
import { SafeReduxInitState } from './SafeReduxInitState';

export const withReduxContext = <T extends WithReduxContextProps>(
  WrappedComponent: ComponentType<T>,
) => {
  class WithReduxContext extends React.Component<T> {
    static defaultProps = {
      name: constants.NAME,
    };

    private readonly reduxContextValue: ReduxContextValue;

    constructor(props: T) {
      super(props);

      const { issueId, workplace, id } = props;

      this.reduxContextValue = createCategorizationSlice(this.props.name, {
        issueId,
        workplace,
        eId: id,
      });
    }

    componentDidMount(): void {
      window.reduxStore.injectReducer(
        this.reduxContextValue.slice.name,
        this.reduxContextValue.reducer,
      );
    }

    componentWillUnmount(): void {
      window.reduxStore.removeReducer(this.reduxContextValue.slice.name);
    }

    render() {
      return (
        <SafeReduxInitState stateKey={this.reduxContextValue.slice.name}>
          <reduxContext.Provider value={this.reduxContextValue}>
            <WrappedComponent {...this.props} />
          </reduxContext.Provider>
        </SafeReduxInitState>
      );
    }
  }

  return WithReduxContext;
};
