import React, { useContext, useCallback } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import css from './TipButton.module.css';
import { tipCallbackContext } from './tipCallbackContext';

interface OwnProps {
  url: string;
  onClick?: (url: string) => void;
}

type Props = OwnProps;

const renderIcon = (cls) => <Icon className={cx(cls, css.TipButton__Icon)} svg="error" />;

export const TipButton: React.FC<Props> = (props) => {
  const { url, onClick } = props;

  const tipCallback = useContext(tipCallbackContext);

  const handleClick = useCallback(
    (event: React.MouseEvent) => {
      event.preventDefault();
      event.stopPropagation();
      tipCallback(url);

      if (onClick) {
        onClick(url);
      }
    },
    [onClick, tipCallback, url],
  );

  return (
    <Button
      view="clear"
      size="xs"
      className={css.TipButton}
      onClick={handleClick}
      icon={renderIcon}
    />
  );
};
