export const VALUE_FROM_TYPE_KEY = Symbol('VALUE_FROM_TYPE_KEY');
export const CATEGORAZATION_V3 = Symbol('CATEGORIZATION_V3');

export enum ValueFromType {
  Inside = 1,
  Outside,
}

export interface SelectedCategoriesMap {
  [key: string]: boolean;
}

export interface SelectedSubCategories {
  [key: string]: number;
}

export interface SelectedCategories {
  [key: string]: SelectedSubCategories;
}

export interface Category {
  id: number;
  fullName: string;
  name: string;
  items?: Category[];
  top: boolean;
  available: boolean;
  hasReasons: boolean;
  forRequest: boolean;
  isLeaf: boolean;
  isReason: boolean;
  selected?: boolean;
}

export type Categories = { [key: string]: Category };

export interface CategorizationValue {
  categories: Categories;
  selectedCategories: SelectedCategories;
  [VALUE_FROM_TYPE_KEY]?: ValueFromType;
}

export interface CategorizationBackendValue {
  categories: Category[];
  selectedCategories: SelectedCategories;
}

export interface CategoryAddPayload {
  categoryId: number;
  category: Category;
}

export interface CategoryRemovePayload {
  categoryId: number;
  subCategoryId?: number;
}

export type CategoriesBackendSave = { id: number }[];
