import { logger } from 'services/Logger';

export default ($categories) => {
  const result = {
    categories: {},
    selectedCategories: {},
  };

  const { categories, selectedCategories } = result;

  try {
    $categories.forEach((category) => {
      categories[category.id] = category;

      const selectedMap = {};
      if (Array.isArray(category.items)) {
        category.items.forEach(({ selected, id }) => {
          if (selected) {
            selectedMap[id] = id;
          }
        });
      }

      selectedCategories[category.id] = selectedMap;
    });
  } catch (error) {
    logger.reportAppErrorOnly(error);
  }

  return result;
};
