import { CategorizationValue, CategorizationBackendValue } from '../types';

export const parseFromBackend2 = (
  categorization?: CategorizationBackendValue,
): CategorizationValue => {
  if (!categorization) {
    return {
      categories: {},
      selectedCategories: {},
    };
  }

  const categories: CategorizationValue['categories'] = categorization.categories.reduce(
    (acc, category) => {
      acc[category.id] = category;
      return acc;
    },
    {},
  );

  return {
    ...categorization,
    categories,
  };
};
