import { ValueAsTreeNode } from '../../types';

export const getFiniteChildren = (valueAsTreeNode: ValueAsTreeNode): number[] => {
  const ids = Object.keys(valueAsTreeNode);
  let result: number[] = [];

  if (!ids.length) {
    return [];
  }

  for (let i = 0, length = ids.length; i < length; i++) {
    const id = ids[i];
    const childrenDeeper = getFiniteChildren(valueAsTreeNode[id]);
    if (!childrenDeeper.length) {
      result.push(Number(id));
      continue;
    }
    result = result.concat(childrenDeeper);
  }

  return result;
};
