import { makeObservable, action } from 'mobx';
import { Configurable } from '../../types';

export abstract class AbstractConfigurator<TParams extends unknown[]>
  implements Configurable<TParams> {
  protected configurable: Configurable<TParams>;

  public constructor(configurable?: Configurable<TParams>) {
    if (configurable) {
      this.configurable = configurable;
    }

    makeObservable(this, {
      setup: action.bound,
    });
  }

  public setup(..._parameters: TParams) {}

  public setConfigurable(configurable: Configurable<TParams>) {
    this.configurable = configurable;
  }
}
