import { makeObservable, observable, action } from 'mobx';

export class BoolState {
  public state: boolean;

  public constructor(defaultState: boolean = false) {
    this.state = defaultState;
    makeObservable(this, {
      state: observable,
      set: action.bound,
      on: action.bound,
      off: action.bound,
    });
  }

  public set(newState: boolean) {
    this.state = newState;
  }

  public on() {
    this.set(true);
  }

  public off() {
    this.set(false);
  }
}
