import { makeObservable, observable, computed } from 'mobx';
import { CategoryDTO, Category as ICategory } from '../../../types';
import { BoolState } from '../BoolState';

export class Category implements ICategory {
  public constructor(categoryDto: CategoryDTO) {
    const { id, parentId, name, items, isLeaf } = categoryDto;
    this.id = id;
    this.parentId = parentId;
    this.name = name;
    this.items = items;
    this.isLeaf = isLeaf;

    makeObservable(this, {
      items: observable,
      isLeaf: observable,
      canExpand: computed,
    });
  }

  public id: number;

  public parentId: number | undefined;

  public items?: number[];

  public name: string;

  public isLeaf: boolean;

  public highlighting = new BoolState(false);

  public check = new BoolState(false);

  public expanding = new BoolState(false);

  public get canExpand() {
    return !this.isLeaf && Array.isArray(this.items) && Boolean(this.items.length);
  }
}
