import { AbstractConfigurator } from '../../AbstractConfigurator';
import { ExternalData, Store } from '../../../../types';
import { createStrategy } from '../../Tree';

export class Configurator extends AbstractConfigurator<[ExternalData?]> {
  protected configurable: Store;

  public constructor(store?: Store) {
    super();
    if (store) {
      this.configurable = store;
    }
  }

  public setup(externalData?: ExternalData) {
    if (!externalData) {
      return;
    }

    const {
      emitter,
      targetMeta,
      load,
      loadTip,
      search,
      save,
      previewComponent,
      changeStrategy = 'multi-branch',
      commentSubmit,
      loadAlerts,
    } = externalData;

    if (emitter) {
      this.configurable.setEmitter(emitter);
    }

    if (targetMeta) {
      this.configurable.targetMeta = targetMeta;
    }

    if (load) {
      this.configurable.setLoadHandler(load);
    }

    if (loadTip) {
      this.configurable.tip.setExternalHandler(loadTip);
    }

    if (commentSubmit) {
      this.configurable.tip.rating.setExternalHandler(commentSubmit);
    }

    if (search) {
      this.configurable.search.setExternalHandler(search);
    }

    if (save) {
      this.configurable.setSaveHandler(save);
    }

    if (previewComponent) {
      this.configurable.previewComponent = previewComponent;
    }

    if (changeStrategy) {
      this.configurable.tree.setChangeStrategy(createStrategy(changeStrategy));
    }

    if (loadAlerts) {
      this.configurable.alertStore.setExternalHandler(loadAlerts);
    }
  }
}
