import { Subject } from 'rxjs';
import {
  Tabs,
  Search,
  Tree,
  Tip,
  EmittingPayload,
  TargetMeta,
  TextHighlighting,
  ExternalData,
  AlertStore,
} from '../../../types';
import { AbstractConfigurator } from '../AbstractConfigurator';

export interface ConstructorConfig {
  emitter?: Subject<{
    event: string;
    payload: TargetMeta & EmittingPayload;
  }>;
  tabs?: Tabs;
  search?: Search;
  tree?: Tree;
  tip?: Tip;
  textHighlighting?: TextHighlighting;
  alertStore?: AlertStore;
  configurator?: AbstractConfigurator<[ExternalData?]>;
}
