import { makeObservable, observable, action } from 'mobx';
import { TabType, Tabs as ITabs, Resetable } from '../../../types';

export class Tabs implements ITabs, Resetable {
  public constructor() {
    makeObservable(this, {
      current: observable,
      previous: observable,
      go: action.bound,
    });
  }

  public current: TabType = 'tree';

  public previous?: TabType;

  public go(tab: TabType) {
    if (tab === this.current) {
      return;
    }

    this.previous = this.current;
    this.current = tab;
  }

  public back() {
    if (this.previous) {
      const tmp = this.current;
      this.current = this.previous;
      this.previous = tmp;
    }
  }

  public reset() {
    this.current = 'tree';
    this.previous = undefined;
  }
}
