import { makeObservable, observable, action } from 'mobx';
import { TextHighlighting as ITextHighlighting, Range, TextHighlightingById } from '../../../types';

export class TextHighlighting implements ITextHighlighting {
  public byId: Record<number, Range[] | undefined> = {};

  public constructor() {
    makeObservable(this, {
      byId: observable,
      setById: action.bound,
      reset: action.bound,
    });
  }

  public setById(byId: TextHighlightingById) {
    this.byId = byId;
  }

  public reset() {
    this.byId = {};
  }
}
