import { makeObservable, action } from 'mobx';
import isPromise from 'utils/isPromise';
import {
  CommentForm as ICommentForm,
  CommentFormExternalHandler,
  Rating as IRating,
  Store as IStore,
} from '../../../../../types';
import { BoolState } from '../../../BoolState';

export class CommentForm implements ICommentForm {
  public constructor() {
    makeObservable(this, {
      comment: action.bound,
    });
  }

  private ratingStore: IRating;

  private mainStore: IStore;

  public setStores(stores: { rating: IRating; main: IStore }) {
    const { rating, main } = stores;
    this.mainStore = main;
    this.ratingStore = rating;
  }

  public openess = new BoolState(false);

  private externalHandler: CommentFormExternalHandler = () => {};

  public setExternalHandler(externalHandler: CommentFormExternalHandler) {
    this.externalHandler = externalHandler;
  }

  public loading = new BoolState(false);

  public comment(categoryId: number, text: string) {
    const rate = this.ratingStore.byId[categoryId];
    const result = this.externalHandler({
      id: categoryId,
      text,
      rate,
    });
    if (isPromise(result)) {
      this.loading.on();
      result
        .then((data) => {
          const id = (data || {}).id;
          this.mainStore.emit('comment', {
            categoryId,
            commentId: id,
          });
          this.openess.off();
        })
        .finally(() => {
          this.loading.off();
        });
      return;
    }
    this.openess.off();
  }

  public reset() {
    this.openess.off();
    this.loading.off();
  }
}
