import { makeObservable, action } from 'mobx';
import { ChangeStrategy } from './types';
import { Tree } from '../../../../types';

export abstract class AbstractStrategy implements ChangeStrategy {
  protected tree: Tree;

  public constructor() {
    makeObservable(this, {
      applyForLeaf: action.bound,
      applyForBranch: action.bound,
    });
  }

  public applyForLeaf(_id: number, _path: number[], _value: boolean) {}

  public applyForBranch(id: number, path: number[], value: boolean) {
    if (this.canInteractWith(path)) {
      this.applyForLeaf(id, path, value);
    }
  }

  public isPathEmpty(path: number[]): boolean {
    return !path.length;
  }

  public isOnlyRootCategory(path: number[]): boolean {
    return path.length === 1;
  }

  public canInteractWith(path: number[]) {
    return !this.isPathEmpty(path) && !this.isOnlyRootCategory(path);
  }

  public setTree(tree: Tree) {
    this.tree = tree;
  }
}
