import { makeObservable, action } from 'mobx';
import cloneDeep from 'lodash/cloneDeep';
import { AbstractStrategy } from '../AbstractStrategy';
import { ChangeStrategy } from '../types';

export class ChangeOnStrategy extends AbstractStrategy implements ChangeStrategy {
  public constructor() {
    super();
    makeObservable(this, {
      makePathInValueAsTree: action.bound,
    });
  }

  public applyForLeaf(id: number, path: number[]) {
    this.makePathInValueAsTree(path);
    this.recursiveLeafApplying(id, path);
  }

  public recursiveLeafApplying(id: number, path: number[]) {
    const { getById } = this.tree;
    const category = getById(id);
    if (!category) {
      return;
    }

    category.check.on();
    if (category.parentId) {
      this.recursiveLeafApplying(category.parentId, path.slice(0, -1));
    }
  }

  public makePathInValueAsTree(path: number[]) {
    const newValueAsTree = cloneDeep(this.tree.valueAsTree.current);
    let node = newValueAsTree;
    path.forEach((id) => {
      if (!node[id]) {
        node[id] = {};
      }
      node = node[id];
    });
    this.tree.valueAsTree.current = newValueAsTree;
  }

  public applyForBranch(id: number, path: number[]) {
    super.applyForBranch(id, path, true);
  }
}
