import { AbstractStrategy } from '../AbstractStrategy';
import { ChangeStrategy } from '../types';

export class ClearStrategy extends AbstractStrategy implements ChangeStrategy {
  public applyForLeaf() {
    const { byId, valueAsTree, root } = this.tree;
    const ids = (Object.keys(byId) as unknown) as number[];
    ids.forEach((id) => {
      const category = byId[id];
      category.check.off();
    });

    root.forEach((id) => {
      valueAsTree.current[id] = {};
    });
  }

  public applyForBranch() {
    this.applyForLeaf();
  }
}
