import { AbstractStrategy } from '../AbstractStrategy';
import { ChangeOnStrategy } from '../ChangeOnStrategy';
import { ChangeOffStrategy } from '../ChangeOffStrategy';
import { Tree } from '../../../../../types';
import { ChangeStrategy } from '../types';

export class MultiBranchStrategy extends AbstractStrategy implements ChangeStrategy {
  private changeOnStrategy = new ChangeOnStrategy();

  private changeOffStrategy = new ChangeOffStrategy();

  public applyForLeaf(id: number, path: number[], value: boolean) {
    if (value) {
      this.changeOnStrategy.applyForLeaf(id, path);
    } else {
      this.changeOffStrategy.applyForLeaf(id, path);
    }
  }

  public applyForBranch(id: number, path: number[], value: boolean) {
    if (!this.canInteractWith(path)) {
      return;
    }

    if (value) {
      this.changeOnStrategy.applyForBranch(id, path);
    } else {
      this.changeOffStrategy.applyForBranch(id, path);
    }
  }

  public setTree(tree: Tree) {
    this.tree = tree;
    this.changeOnStrategy.setTree(tree);
    this.changeOffStrategy.setTree(tree);
  }
}
