import { AbstractStrategy } from '../AbstractStrategy';
import { ChangeOnStrategy } from '../ChangeOnStrategy';
import { ChangeOffStrategy } from '../ChangeOffStrategy';
import { ClearStrategy } from '../ClearStrategy';
import { Tree } from '../../../../../types';
import { ChangeStrategy } from '../types';

export class OneBranchStrategy extends AbstractStrategy implements ChangeStrategy {
  private clearStrategy = new ClearStrategy();

  private changeOnStrategy = new ChangeOnStrategy();

  private changeOffStrategy = new ChangeOffStrategy();

  public applyForLeaf(id: number, path: number[], value: boolean) {
    if (value) {
      this.clearStrategy.applyForLeaf();
      this.changeOnStrategy.applyForLeaf(id, path);
      return;
    }

    this.changeOffStrategy.applyForLeaf(id, path);
  }

  public applyForBranch(id: number, path: number[], value: boolean) {
    if (!this.canInteractWith(path)) {
      return;
    }

    if (value) {
      this.clearStrategy.applyForBranch();
      this.changeOnStrategy.applyForBranch(id, path);
    } else {
      this.changeOffStrategy.applyForBranch(id, path);
    }
  }

  public setTree(tree: Tree) {
    this.clearStrategy.setTree(tree);
    this.changeOnStrategy.setTree(tree);
    this.changeOffStrategy.setTree(tree);
  }
}
