import { ChangeStrategyType } from '../../../../types';
import { ChangeStrategy } from './types';
import { MultiBranchStrategy } from './MultiBranchStrategy';
import { OneBranchStrategy } from './OneBranchStrategy';

export const createStrategy = (strategyType: ChangeStrategyType): ChangeStrategy => {
  if (strategyType === 'one-branch') {
    return new OneBranchStrategy();
  }

  return new MultiBranchStrategy();
};
