import cloneDeep from 'lodash/cloneDeep';
import { CategoriesObject } from '../../../../types';
import { Tree } from '../Tree';
import { getValueAsTreeIds } from './Configurator.utils';
import { AbstractConfigurator } from '../../AbstractConfigurator';

export class Configurator extends AbstractConfigurator<[CategoriesObject]> {
  protected configurable: Tree;

  public constructor(tree?: Tree) {
    super();
    if (tree) {
      this.configurable = tree;
    }
  }

  public setup(categoriesObject: CategoriesObject) {
    const { byId, root, valueAsTree, highlightPath } = categoriesObject;
    this.configurable.jsonById = { ...byId };
    root.forEach((id) => {
      this.configurable.initCategoryDTOById(id);
    });
    this.configurable.root = root;
    if (Array.isArray(highlightPath)) {
      this.configurable.highlightPath = highlightPath;
    }
    getValueAsTreeIds(valueAsTree).forEach((id: number) => {
      const category = this.configurable.getById(id);
      if (category) {
        category.check.on();
      }
    });
    this.configurable.valueAsTree = {
      current: valueAsTree,
      initial: cloneDeep(valueAsTree),
    };
  }
}
