import { ValueAsTreeNode } from '../../../../types';

export const getValueAsTreeIds = (valueAsTree: ValueAsTreeNode): number[] => {
  let result: number[] = [];
  Object.keys(valueAsTree).forEach((id) => {
    result.push(Number(id));
    if (valueAsTree[id]) {
      result = [...result, ...getValueAsTreeIds(valueAsTree[id])];
    }
  });

  return result;
};
