import React, { FC, useState } from 'react';
import { observer } from 'mobx-react-lite';
import { Tip } from 'components/Tip2';
import cx from 'classnames';
import { AlertContent } from './AlertContent';
import { AlertFullScreen } from './AlertFullScreen';
import { AlertButton } from './AlertButton';
import { AlertProps } from './Alert.types';
import css from './Alert.module.css';

export const Alert: FC<AlertProps> = observer((props) => {
  const { alertStore, tree } = props;
  const { visibleAlert } = alertStore;
  const [isFullScreen, setFullScreen] = useState(false);

  if (!visibleAlert) {
    return null;
  }

  const renderContent = (onFullScreen) => (
    <AlertContent alertStore={alertStore} onViewBugsClick={onFullScreen} />
  );

  const renderFullScreen = (onClose) => (
    <AlertFullScreen alertStore={alertStore} tree={tree} onCrossClick={onClose} />
  );

  const renderButton = (isExpanded: boolean, onExpand: () => void) => (
    <AlertButton
      alertStore={alertStore}
      onClick={onExpand}
      arrowDirection={isExpanded ? 'top' : 'bottom'}
    />
  );

  const className = cx(css.Alert, props.className);

  return (
    <Tip
      className={className}
      renderContent={renderContent}
      renderFullScreen={renderFullScreen}
      isExpanded={alertStore.expanding.state}
      onExpandChange={alertStore.expanding.set}
      isFullScreen={isFullScreen}
      onFullScreenChange={setFullScreen}
      role="alert"
    >
      {renderButton}
    </Tip>
  );
});
