import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import Icon from '@crm/components/dist/lego2/Icon';
import { AlertButtonProps } from './AlertButton.types';
import css from './AlertButton.module.css';
import { modifiedOn } from './AlertButton.utils';

export const AlertButton: FC<AlertButtonProps> = observer((props) => {
  const { alertStore, arrowDirection, onClick } = props;
  const { visibleAlert } = alertStore;

  if (!visibleAlert) {
    return null;
  }

  return (
    <div className={css.AlertButton} onClick={onClick}>
      <div>
        <div className={css.AlertButton__top}>Ошибка - Обновлено {modifiedOn(visibleAlert)}</div>
        <h4 className={css.AlertButton__title}>{visibleAlert.name}</h4>
      </div>
      <Icon
        className={css.AlertButton__arrow}
        size="m"
        direction={arrowDirection}
        glyph="type-arrow"
      />
    </div>
  );
});
