import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import Button from '@crm/components/dist/lego2/Button';
import { AlertContentProps } from './AlertContent.types';
import css from './AlertContent.module.css';

export const AlertContent: FC<AlertContentProps> = observer((props) => {
  const { alertStore, onViewBugsClick } = props;
  const { visibleAlert } = alertStore;

  if (!visibleAlert) {
    return null;
  }

  return (
    <div className={css.AlertContent}>
      {visibleAlert.description && (
        <div
          className={css.AlertContent__description}
          role="article"
          dangerouslySetInnerHTML={{ __html: visibleAlert.description }}
        />
      )}
      {alertStore.hasRelatedAlerts && (
        <div className={css.AlertContent__bottomLine}>
          <span className={css.AlertContent__warning}>Есть связанные баги!</span>
          <Button
            className={css.AlertContent__viewBugs}
            view="clear"
            size="xs"
            onClick={onViewBugsClick}
          >
            Посмотреть
          </Button>
        </div>
      )}
    </div>
  );
});
