import React, { FC } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import { AlertFullScreenProps } from './AlertFullScreen.types';
import css from './AlertFullScreen.module.css';
import { RelatedAlerts } from './RelatedAlerts';

export const AlertFullScreen: FC<AlertFullScreenProps> = (props) => {
  return (
    <div role="dialog" aria-label="related bugs modal" className={css.AlertFullScreen}>
      <h4 className={css.AlertFullScreen__title}>Связанные баги</h4>
      <Button
        view="clear"
        className={css.AlertFullScreen__cross}
        onClick={props.onCrossClick}
        icon={(iconCls) => <Icon className={iconCls} size="xs" glyph="type-cross" />}
      />
      <RelatedAlerts tree={props.tree} alertStore={props.alertStore} />
    </div>
  );
};
