import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import cx from 'classnames';
import { ItemProps } from './Item.types';
import css from './Item.module.css';
import { getPathFromHighestParent } from '../../../../../utils';
import { modifiedOn } from '../../../AlertButton/AlertButton.utils';

export const Item: FC<ItemProps> = observer((props) => {
  const { alert, tree, hasSplitter } = props;
  const { getById } = tree;
  const categoryFullName = getPathFromHighestParent(getById, alert.category.id)
    .map((categoryId) => getById(categoryId)!.name)
    .join(' / ');

  const className = cx(css.Item, props.className, {
    [css.Item_hasSplitter]: hasSplitter,
  });

  return (
    <div className={className} role="listitem">
      <h5 className={css.Item__title}>{alert.name}</h5>
      <div className={css.Item__category}>
        <span className={css.Item__grayText}>Категория:&nbsp;</span>
        <span>{categoryFullName}</span>
      </div>
      <div>
        <span className={css.Item__grayText}>Обновлено {modifiedOn(alert)}</span>
      </div>

      {alert.description && (
        <div
          className={css.Item__description}
          dangerouslySetInnerHTML={{ __html: alert.description }}
        />
      )}
    </div>
  );
});
