import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import { Item } from './Item';
import { RelatedAlertsProps } from './RelatedAlerts.types';
import css from './RelatedAlerts.module.css';

export const RelatedAlerts: FC<RelatedAlertsProps> = observer((props) => {
  const { alertStore, tree } = props;
  const { relatedAlerts } = alertStore;

  return (
    <div className={css.RelatedAlerts}>
      {relatedAlerts.map((alert, index) => (
        <Item
          key={alert.id}
          alert={alert}
          tree={tree}
          className={css.RelatedAlerts__item}
          hasSplitter={relatedAlerts.length - 1 !== index}
        />
      ))}
    </div>
  );
});
