import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import css from './AllSelected.module.css';
import { Category, hocs as categoryHocs } from '../Category';
import { useContextState } from '../../State';
import { getPathFromHighestParent } from '../../utils';
import { AllSelectedProps } from './AllSelected.types';

const BreadcrumbedCategory = categoryHocs.withBreadcrumbs(Category);

export const AllSelected: FC<AllSelectedProps> = observer((props) => {
  const state = useContextState();
  const { onChange } = props;
  const { tree, tabs, search } = state;
  const { getById, changeBranchValue, selectCategory, finiteSelected } = tree;
  const { setText } = search;

  const goToCategoryInTree = (id: number) => {
    selectCategory(id);
    tabs.go('tree');
  };

  const handleBreadcrumbsClick = (id: number) => {
    setText('');
    goToCategoryInTree(id);
  };

  const handleChange = (id: number, value: boolean) => {
    changeBranchValue(id, value);
    if (onChange) {
      onChange(id, value);
    }
  };

  return (
    <div className={css.AllSelected} role="list">
      {finiteSelected
        .filter((id) => Boolean(getById(id)))
        .map((id) => {
          const category = getById(id)!;
          const breadcrumbsPath = getPathFromHighestParent(getById, id).map((id) => getById(id)!);

          return (
            <BreadcrumbedCategory
              key={id}
              category={category}
              role="listitem"
              breadcrumbsPath={breadcrumbsPath}
              onBreadcrumbsClick={handleBreadcrumbsClick}
              onCategoryChange={handleChange}
              onCategoryClick={selectCategory}
            />
          );
        })}
    </div>
  );
});
