import React, { ComponentType } from 'react';
import { observer } from 'mobx-react-lite';
import { AllSelectedProps } from './AllSelected.types';
import { useContextState } from '../../State';
import { EmittingPayload } from '../../types';

export const withEmitting = (AllSelected: ComponentType<AllSelectedProps>) =>
  observer(() => {
    const state = useContextState();
    const { tree, emit } = state;
    const { finiteSelected } = tree;

    const handleChange = (id: number, value: boolean) => {
      const data: EmittingPayload = {
        block: 'selected',
        categoryId: id,
        resultsCount: finiteSelected.length,
        order: finiteSelected.findIndex((categoryId) => categoryId === id) + 1,
      };

      if (value) {
        emit('categoryTurnOn', data);
      } else {
        emit('categoryTurnOff', data);
      }
    };

    return <AllSelected onChange={handleChange} />;
  });
