import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import css from './Categorization.module.css';
import { useContextState } from '../../State';
import { TopBar } from '../TopBar';
import { Tree } from '../Tree';
import { SearchResults } from '../SearchResults';
import { AllSelected } from '../AllSelected';
import { Tip } from '../Tip';
import { Alert } from '../Alert';

export const Categorization: FC = observer(() => {
  const state = useContextState();
  const { tabs, alertStore, tree } = state;

  let renderedTab: React.ReactNode = null;
  switch (tabs.current) {
    case 'search': {
      renderedTab = <SearchResults />;
      break;
    }

    case 'selected': {
      renderedTab = <AllSelected />;
      break;
    }

    default: {
      renderedTab = <Tree />;
      break;
    }
  }

  return (
    <div className={css.Categorization}>
      <TopBar />

      <div className={css.Categorization__content}>
        {renderedTab}
        <div className={css.Categorization__rightPart}>
          <Alert tree={tree} alertStore={alertStore} className={css.Categorization__alert} />
          <Tip className={css.Categorization__tip} />
        </div>
      </div>
    </div>
  );
});
