import React, { FC } from 'react';
import { Category as DesignCategory } from 'components/design/Category';
import { observer } from 'mobx-react-lite';
import { CategoryProps } from './Category.types';

export const Category: FC<CategoryProps> = observer((props) => {
  const {
    category,
    canClick = true,
    canSelect = true,
    onChange,
    onClick,
    content = category.name,
    hasExpandingArrow = false,
    hasTransitionButton = false,
    onTransitionClick,
    role,
  } = props;

  if (!category) {
    return null;
  }

  const handleClick = () => {
    if (onClick) {
      onClick(category.id);
    }
  };

  const handleCheck = (value: boolean) => {
    if (onChange) {
      onChange(category.id, value);
    }
  };

  return (
    <DesignCategory
      canClick={canClick}
      onClick={handleClick}
      isHighlighted={category.highlighting.state}
      canCheck={canSelect}
      onCheck={handleCheck}
      isChecked={category.check.state}
      canDoubleClickChecked
      content={content}
      hasExpandingArrow={hasExpandingArrow}
      hasTransitionButton={hasTransitionButton}
      onTransitionClick={onTransitionClick}
      role={role}
    />
  );
});
