import React, { FC, Fragment } from 'react';
import { observer } from 'mobx-react-lite';
import { BreadcrumbsProps } from './Breadcrumbs.types';
import { Item } from './Item';
import css from './Breadcrumbs.module.css';

export const Breadcrumbs: FC<BreadcrumbsProps> = observer((props) => {
  const lastIndex = props.path.length - 1;

  return (
    <div className={css.Breadcrumbs}>
      {props.path.map((category, index) => (
        <Fragment key={category.id}>
          {index !== 0 && (
            <span className={css.Breadcrumbs__splitter} role="separator">
              /
            </span>
          )}
          <Item
            key={category.id}
            id={category.id}
            text={category.name}
            onClick={props.onClick}
            textColor={props.isHighlighted ? '#fff' : undefined}
            clickable={index !== lastIndex}
          />
        </Fragment>
      ))}
    </div>
  );
});
