import React, { FC, CSSProperties, ReactNode } from 'react';
import cx from 'classnames';
import { observer } from 'mobx-react-lite';
import css from './Item.module.css';
import { ItemProps } from './Item.types';
import { renderHighlightedText } from './Item.utils';
import { useContextState } from '../../../../../../State';

const highlightRender = (text: string) => <span className={css.Item__highlighting}>{text}</span>;

export const Item: FC<ItemProps> = observer((props) => {
  const state = useContextState();
  const { textHighlighting } = state;
  const { text, id, clickable, onClick, textColor } = props;

  const handleClick = (event: React.MouseEvent) => {
    if (onClick && clickable) {
      event.stopPropagation();
      onClick(id);
    }
  };

  const className = cx(css.Item, props.className, {
    [css.Item_clickable]: clickable,
  });

  const style: CSSProperties = {
    color: textColor,
  };

  let renderedContent: ReactNode = text;
  const ranges = textHighlighting.byId[id];
  if (ranges) {
    renderedContent = renderHighlightedText(text, ranges, highlightRender);
  }

  return (
    <span className={className} style={style} onClick={handleClick}>
      {renderedContent}
    </span>
  );
});
