import React from 'react';
import { Range } from '../../../../../../types';

export const renderHighlightedText = (
  text: string,
  ranges: Range[],
  highlightRender: (text: string) => React.ReactNode,
) => {
  if (!ranges.length) {
    return text;
  }

  const result: React.ReactNode[] = [];
  const [firstStart] = ranges[0];
  if (firstStart > 0) {
    result.push(text.slice(0, firstStart));
  }

  let previousEnd: number | undefined;
  for (let i = 0; i < ranges.length; i++) {
    let [start, end] = ranges[i];
    if (previousEnd != null) {
      result.push(text.slice(previousEnd, start));
    }

    result.push(highlightRender(text.slice(start, end + 1)));
    previousEnd = end + 1;
  }

  if ((previousEnd as number) < text.length) {
    result.push(text.slice(previousEnd, text.length));
  }

  return result;
};
