import React, { ComponentType } from 'react';
import { observer } from 'mobx-react-lite';
import { CategoryProps } from '../../Category.types';
import { Breadcrumbs } from './Breadcrumbs';
import { WithBreadcrumbsProps } from './withBreadcrumbs.types';

export const withBreadcrumbs = (Category: ComponentType<CategoryProps>) =>
  observer((props: WithBreadcrumbsProps) => {
    const {
      breadcrumbsPath,
      onBreadcrumbsClick,
      onCategoryClick,
      onCategoryChange,
      role,
      category,
    } = props;
    const { highlighting, id } = category;

    const handleTransitionClick = () => {
      onBreadcrumbsClick(id);
    };

    return (
      <Category
        category={category}
        role={role}
        content={
          <Breadcrumbs
            path={breadcrumbsPath}
            isHighlighted={highlighting.state}
            onClick={onBreadcrumbsClick}
          />
        }
        onClick={onCategoryClick}
        onChange={onCategoryChange}
        hasTransitionButton
        onTransitionClick={handleTransitionClick}
      />
    );
  });
