import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import { ExpandWidget as ExpandComponent } from 'components/ExpandWidget';
import { useContextState } from '../../State';
import { ExpandWidgetProps } from './ExpandWidget.types';

export const ExpandWidget: FC<ExpandWidgetProps> = observer((props) => {
  const state = useContextState();
  const { fullness, openess, targetMeta } = state;
  const { className } = props;

  const description = (targetMeta || {}).description;

  if (!openess.state || fullness.state) {
    return null;
  }

  const text =
    description && description.length
      ? `Текущая разметка: ${description}`
      : 'Разметка не завершена';

  return <ExpandComponent text={text} className={className} onClick={fullness.on} />;
});
