import ReactDOM from 'react-dom';
import React, { FC, useEffect, useMemo } from 'react';
import { observer } from 'mobx-react-lite';
import { useContextState } from '../../State';
import { ModalContent } from './ModalContent';

export const Modal: FC = observer(() => {
  const state = useContextState();
  const { openess, fullness, previewComponent: Preview, close, save } = state;
  const visible = useMemo(() => openess.state && fullness.state, [openess.state, fullness.state]);

  useEffect(
    () => () => {
      if (openess.state && state.hasChanges) {
        save();
        return;
      }
      close();
    },
    [],
  );

  if (!visible) {
    return null;
  }

  /*
   * Приходится навешивать onClick и на ноду со скроллом, т.к она прозрачная и
   * визуально ты все еще кликаешь на оверлей, и ожидаешь сворачивания модалки.
   * Стопаем распространение для того, чтобы модалка не сворачивалась по клику на превью.
   */
  return ReactDOM.createPortal(
    <ModalContent onClick={fullness.off} visible={visible}>
      {Preview && <Preview />}
    </ModalContent>,
    document.body,
  );
});
