import React from 'react';
import { Overlay } from 'components/Overlay';
import { withZIndex } from '@yandex-lego/components/withZIndex';
import cx from 'classnames';
import { config } from 'services/Config';
import { Categorization } from '../../Categorization';
import css from './ModalContent.module.css';
import { ModalContentProps } from './ModalContent.types';
import { modalTestId } from './ModalContent.constants';
import { withEventAnchor, EventAnchorProps } from 'components/UXLogger/EventAnchor';
import { compose } from 'recompose';

const stopPropagation = (event) => event.stopPropagation();

const ModalContentBase = ({ children, onClick, innerRef }) => {
  const issueTimelineV2 = config.value.features.issueTimelineV2;
  return (
    <div ref={innerRef} className={css.ModalContent} role="dialog" data-testid={modalTestId}>
      <Overlay display hasSpinner={false} color="rgba(19,19,18,.8)" onClick={onClick} />
      <div
        className={cx(css.ModalContent__previewWrap, {
          [css.ModalContent__previewWrap_padded]: !issueTimelineV2,
        })}
        onClick={onClick}
      >
        <div
          className={cx({ [css.ModalContent__preview]: issueTimelineV2 })}
          onClick={stopPropagation}
        >
          {children}
        </div>
      </div>
      <Categorization />
    </div>
  );
};

export const ModalContent = compose(
  withZIndex,
  withEventAnchor,
)(ModalContentBase) as React.FC<ModalContentProps & EventAnchorProps>;
