import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import { getPathFromHighestParent } from 'modules/categorization2/utils';
import { Category, hocs as categoryHocs } from '../../../Category';
import { ResultItemProps } from './ResultItem.types';

const BreadcrumbedCategory = categoryHocs.withBreadcrumbs(Category);

export const ResultItem: FC<ResultItemProps> = observer((props) => {
  const { id, getById, onBreadcrumbsClick, onCategoryClick, onCategoryChange } = props;

  const category = getById(id);
  if (!category) {
    return null;
  }

  const breadcrumbsPath = getPathFromHighestParent(getById, id).map((id) => getById(id)!);

  return (
    <BreadcrumbedCategory
      key={category.id}
      category={category}
      role="listitem"
      breadcrumbsPath={breadcrumbsPath}
      onBreadcrumbsClick={onBreadcrumbsClick}
      onCategoryClick={onCategoryClick}
      onCategoryChange={onCategoryChange}
    />
  );
});
