import React, { FC } from 'react';
import { Virtuoso } from 'react-virtuoso';
import { observer } from 'mobx-react-lite';
import { ResultsListProps } from './ResultsList.types';
import { ResultItem } from './ResultItem';

export const ResultsList: FC<ResultsListProps> = observer((props) => {
  const { resultIds, getById, onChange, onCategoryClick, onBreadcrumbsClick } = props;

  return (
    <Virtuoso
      initialItemCount={process.env.NODE_ENV === 'test' ? resultIds.length : undefined}
      totalCount={resultIds.length}
      overscan={100}
      itemContent={(index) => {
        const id = resultIds[index];

        return (
          <ResultItem
            id={id}
            getById={getById}
            onBreadcrumbsClick={onBreadcrumbsClick}
            onCategoryClick={onCategoryClick}
            onCategoryChange={onChange}
          />
        );
      }}
    />
  );
});
