import React, { FC } from 'react';
import Spin from '@crm/components/dist/lego2/Spin';
import { observer } from 'mobx-react-lite';
import { noCategoriesFoundTestId, spinnerTestId, errorTextTestId } from './SearchResults.constants';
import css from './SearchResults.module.css';
import { useContextState } from '../../State';
import { SearchResultsProps } from './SearchResults.types';
import { ResultsList } from './ResultsList';

export const SearchResults: FC<SearchResultsProps> = observer((props) => {
  const state = useContextState();
  const { onChange } = props;
  const { search, tree, tabs } = state;
  const { getById, changeBranchValue, selectCategory } = tree;
  const { loading, error, resultIds } = search;

  const goToCategoryInTree = (id: number) => {
    selectCategory(id);
    tabs.go('tree');
  };

  const handleChange = (id: number, value: boolean) => {
    changeBranchValue(id, value);
    if (onChange) {
      onChange(id, value);
    }
  };

  return (
    <div className={css.SearchResults} role="list">
      {loading.state && !error.state && (
        <Spin data-testid={spinnerTestId} progress size="m" position="center" view="default" />
      )}
      {!loading.state && error.state && (
        <span className={css.SearchResults__infoText} data-testid={errorTextTestId}>
          Произошла ошибка
        </span>
      )}
      {!loading.state && !error.state && !resultIds.length && (
        <span className={css.SearchResults__infoText} data-testid={noCategoriesFoundTestId}>
          Категории не найдены
        </span>
      )}
      {!loading.state && !error.state && Boolean(resultIds.length) && (
        <ResultsList
          getById={getById}
          onCategoryClick={selectCategory}
          onBreadcrumbsClick={goToCategoryInTree}
          onChange={handleChange}
          resultIds={resultIds}
        />
      )}
    </div>
  );
});
