import React, { ComponentType } from 'react';
import { observer } from 'mobx-react-lite';
import { SearchResultsProps } from './SearchResults.types';
import { useContextState } from '../../State';
import { EmittingPayload } from '../../types';

export const withEmitting = (SearchResults: ComponentType<SearchResultsProps>) =>
  observer(() => {
    const state = useContextState();
    const { emit, search } = state;
    const { resultIds } = search;

    const handleChange = (id: number, value: boolean) => {
      const data: EmittingPayload = {
        block: 'search',
        categoryId: id,
        resultsCount: resultIds.length,
        order: resultIds.findIndex((categoryId) => categoryId === id) + 1,
      };

      if (value) {
        emit('categoryTurnOn', data);
      } else {
        emit('categoryTurnOff', data);
      }
    };

    return <SearchResults onChange={handleChange} />;
  });
