import React, { FC } from 'react';
import css from './ButtonPanel.module.css';
import { ExpandButton } from '../ExpandButton';
import { RateButton } from '../RateButton';
import { ButtonPanelProps } from './ButtonPanel.types';

export const ButtonPanel: FC<ButtonPanelProps> = (props) => {
  return (
    <div>
      <ExpandButton
        className={css.ButtonPanel__expandButton}
        expanded={props.isExpanded}
        onToggle={props.onExpandToggle}
        disabled={props.disabled}
      />
      <RateButton
        type="like"
        className={css.ButtonPanel__likeButton}
        onClick={props.onLikeClick}
        onWantToComment={props.onWantToComment}
        aria-label="like"
        clicked={props.rating === true}
        disabled={props.disabled}
      />
      <RateButton
        type="dislike"
        className={css.ButtonPanel__dislikeButton}
        onClick={props.onDislikeClick}
        onWantToComment={props.onWantToComment}
        aria-label="dislike"
        clicked={props.rating === false}
        disabled={props.disabled}
      />
    </div>
  );
};
