/* eslint-disable react/jsx-no-bind */
import React, { FC } from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import { ExpandButtonProps } from './ExpandButton.types';
import css from './ExpandButton.module.css';

export const ExpandButton: FC<ExpandButtonProps> = (props) => {
  const { expanded = false, disabled = false } = props;

  const handleClick = () => {
    if (props.onToggle) {
      props.onToggle(!expanded);
    }
  };

  const className = cx(props.className, css.ExpandButton);

  return (
    <button className={className} aria-label="expand" onClick={handleClick} disabled={disabled}>
      <Icon svg={expanded ? 'shrink' : 'expand'} />
    </button>
  );
};
