import React, { FC, useState } from 'react';
import { Overlay } from 'components/Overlay';
import Textarea from '@crm/components/dist/lego2/Textarea';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import css from './Form.module.css';
import './Form.css';
import { FormProps } from './Form.types';
import { BORDER_RADIUS } from './Form.constants';

export const Form: FC<FormProps> = (props) => {
  const { onSubmit, isLoading } = props;

  const [text, setText] = useState('');

  const handleChange = (event: React.ChangeEvent<HTMLTextAreaElement>) => {
    setText(event.target.value);
  };

  const handleSendClick = () => {
    onSubmit(text);
  };

  return (
    <div className={cx(css.Form, props.className)}>
      <Textarea
        className={cx(css.Form__textarea, 'Form__textarea')}
        value={text}
        onChange={handleChange}
        placeholder="Комментарий..."
      />
      <footer className={css.Form__footer}>
        <Button
          view="action"
          className={css.Form__sendButton}
          size="m"
          onClick={handleSendClick}
          disabled={!text.length || isLoading}
        >
          Отправить
        </Button>
      </footer>
      {isLoading && <Overlay display color="rgba(0, 0, 0, .4)" borderRadius={BORDER_RADIUS} />}
    </div>
  );
};
