import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import { Overlay } from 'components/Overlay';
import FocusLock from 'react-focus-lock';
import { FullScreen } from 'components/FullScreen';
import { Form } from './Form';
import { LeaveCommentProps } from './LeaveComment.types';
import css from './LeaveComment.module.css';

export const LeaveComment: FC<LeaveCommentProps> = observer((props) => {
  const { commentForm, categoryId } = props;
  const { openess, comment, loading } = commentForm;

  const handleSubmit = (text: string) => {
    comment(categoryId, text);
  };

  return (
    <>
      {openess.state && (
        <FullScreen>
          <FocusLock className={css.LeaveComment__focusLockWrap}>
            <Overlay display hasSpinner={false} color="rgba(0, 0, 0, .4)" onClick={openess.off} />
            <Form
              onSubmit={handleSubmit}
              isLoading={loading.state}
              className={css.LeaveComment__form}
            />
          </FocusLock>
        </FullScreen>
      )}
    </>
  );
});
