import React, { ComponentType } from 'react';
import { observer } from 'mobx-react-lite';
import { TipProps } from './Tip.types';
import { useContextState } from '../../State';

export const withEmitting = (Tip: ComponentType<TipProps>) =>
  observer((props: Omit<TipProps, 'onToggle' | 'onLikeClick' | 'onDislikeClick' | 'onTipOpen'>) => {
    const state = useContextState();
    const { tree, emit, tip, tabs } = state;
    const { rating } = tip;
    const { lastHighlighted } = tree as { lastHighlighted: number };

    const handleToggle = (expand: boolean) => {
      if (expand) {
        emit('tipExpand', {
          block: 'categorization',
          categoryId: lastHighlighted,
        });
      }
    };

    const handleLikeClick = () => {
      if (rating.byId[lastHighlighted]) {
        emit('like', {
          categoryId: lastHighlighted,
        });
      }
    };

    const handleDislikeClick = () => {
      if (rating.byId[lastHighlighted] === false) {
        emit('dislike', {
          categoryId: lastHighlighted,
        });
      }
    };

    const handleTipOpen = () => {
      emit('tipOpen', {
        block: tabs.current,
        categoryId: lastHighlighted,
      });
    };

    return (
      <Tip
        onLikeClick={handleLikeClick}
        onDislikeClick={handleDislikeClick}
        onTipOpen={handleTipOpen}
        onToggle={handleToggle}
        {...props}
      />
    );
  });
