import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import Button from '@crm/components/dist/lego2/Button';
import { useContextState } from '../../../State';
import { SaveButtonProps } from './SaveButton.types';

export const SaveButton: FC<SaveButtonProps> = observer((props) => {
  const state = useContextState();
  const { hasChanges, save, emit } = state;

  const handleClick = () => {
    save();
    emit('save');
  };

  return (
    <Button className={props.className} view="action" onClick={handleClick} disabled={!hasChanges}>
      Сохранить
    </Button>
  );
});
