import React, { FC, useRef } from 'react';
import { observer } from 'mobx-react-lite';
import { useFocusKeeping } from 'utils/hooks/useFocusKeeping';
import Textinput from '@crm/components/dist/lego2/Textinput';
import { useContextState } from '../../../State';
import { SearchInputProps } from './SearchInput.types';

export const SearchInput: FC<SearchInputProps> = observer((props) => {
  const state = useContextState();
  const { handler, text } = state.search;

  const textinputRef = useRef<HTMLInputElement>(null);
  useFocusKeeping(textinputRef);

  return (
    <Textinput
      className={props.className}
      onChange={handler}
      placeholder="Поиск категории"
      value={text}
      controlRef={textinputRef}
    />
  );
});
